function test_suite = testProd %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
x = polysym.empty;
assertTrue(isempty(prod(x)))

function testDefault
x = polysym;
assertTrue(iszero(prod(x)))

function testRealScalar
x = polysym(pi);
assertEqual(prod(x),x);

function testCharScalar
x = polysym('x');
assertEqual(prod(x),x);

function testArrayOfOnes
x = polysym(ones(3,1));
assertEqual(prod(x),polysym(1))

function testRealVectorWithUnity
x = polysym(1:3);
assertEqual(prod(x),x(2)*x(3));

function testCharVector
x = polysym('x',[3 1]);
assertEqual(prod(x),x(1)*x(2)*x(3));

function testMatrix
x = polysym('x',2);
assertEqual(prod(x),x(1,:).*x(2,:));

function testMatrixSecondDim
x = polysym('x',2);
assertEqual(prod(x,2),x(:,1).*x(:,2));

function testDimTooLarge
polysyms('x')
f = @() x.prod(3);
assertExceptionThrown(f,'MATLAB:polysym:diff:notLess')

function testDimTooSmall
polysyms('x')
f = @() x.prod(0);
assertExceptionThrown(f,'MATLAB:polysym:diff:notGreater')
